/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.launcher;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import technology.rocketjump.undermount.assets.entities.wallcap.model.WallCapAsset;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.RoomEdgeType;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.launcher.model.ModManifest;
import technology.rocketjump.undermount.launcher.model.TerrainAssetDescriptor;

public class ModPacker {
    private ObjectMapper objectMapper = new ObjectMapper();

    public ModPacker() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public void packageModsToAssets(List<ModManifest> mods, FileHandle assetDir) throws IOException {
        if (!assetDir.exists()) {
            throw new FileNotFoundException(assetDir.path());
        }
        ModManifest modManifest = mods.get(0);
        FileHandle environmentDir = this.createEmptySubdir(assetDir, "environment");
        FileUtils.writeStringToFile(environmentDir.child("sunlight.json").file(), this.objectMapper.writeValueAsString(modManifest.getSunlightPhases()));
        FileHandle definitionsDir = this.createEmptySubdir(assetDir, "definitions");
        FileUtils.writeStringToFile(definitionsDir.child("materials.json").file(), this.objectMapper.writeValueAsString(modManifest.getDefinedMaterials()));
        FileUtils.writeStringToFile(definitionsDir.child("overlaps.json").file(), this.objectMapper.writeValueAsString(modManifest.getAlphaMaskOverlapTypes()));
        FileUtils.writeStringToFile(definitionsDir.child("plantSpecies.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getPlantSpeciesList()));
        FileUtils.writeStringToFile(definitionsDir.child("itemTypes.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getItemTypeList()));
        FileUtils.writeStringToFile(definitionsDir.child("furnitureLayouts.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getFurnitureLayoutList()));
        FileUtils.writeStringToFile(definitionsDir.child("furnitureCategories.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getFurnitureCategoryList()));
        FileUtils.writeStringToFile(definitionsDir.child("furnitureTypes.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getFurnitureTypeList()));
        for (FileHandle otherManifestFile : modManifest.getOtherDefinitionFiles()) {
            FileUtils.copyFileToDirectory(otherManifestFile.file(), definitionsDir.file());
        }
        FileHandle finalTilesetsDir = this.createEmptySubdir(assetDir, "tilesets");
        FileHandle musicAssetsDir = this.createEmptySubdir(assetDir, "music");
        for (FileHandle fileHandle : modManifest.getMusicFiles()) {
            FileUtils.copyFileToDirectory(fileHandle.file(), musicAssetsDir.file());
        }
        FileHandle assetDefinitionsDir = this.createEmptySubdir(definitionsDir, "entityAssets");
        FileUtils.copyFile(modManifest.getEntityAssetManifest().getRenderLayersJsonFile().file(), assetDefinitionsDir.child("renderLayers.json").file());
        FileUtils.copyFile(modManifest.getEntityAssetManifest().getEntityAssetTypesJsonFile().file(), assetDefinitionsDir.child("entityAssetTypes.json").file());
        FileUtils.writeStringToFile(assetDefinitionsDir.child("humanoidEntityAssets.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getHumanoidEntityAssets()));
        FileUtils.writeStringToFile(assetDefinitionsDir.child("plantEntityAssets.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getPlantEntityAssets()));
        FileUtils.writeStringToFile(assetDefinitionsDir.child("itemEntityAssets.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getItemEntityAssets()));
        FileUtils.writeStringToFile(assetDefinitionsDir.child("furnitureEntityAssets.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getFurnitureEntityAssets()));
        for (WallCapAsset wallCapAsset : modManifest.getEntityAssetManifest().getWallCapAssets()) {
            WallType matchingWallType = null;
            for (TerrainAssetDescriptor terrainAssetDescriptor : modManifest.getTerrainAssetDescriptors()) {
                if (!terrainAssetDescriptor.getType().equals("wall") || !terrainAssetDescriptor.getWallType().getWallTypeName().equals(wallCapAsset.getWallTypeName())) continue;
                matchingWallType = terrainAssetDescriptor.getWallType();
                break;
            }
            if (matchingWallType == null) {
                throw new RuntimeException("Could not find wall type " + wallCapAsset.getWallTypeName() + " for wall cap asset " + wallCapAsset.getUniqueName());
            }
            wallCapAsset.setWallTypeId(matchingWallType.getWallTypeId());
        }
        FileUtils.writeStringToFile(assetDefinitionsDir.child("wallCapAssets.json").file(), this.objectMapper.writeValueAsString(modManifest.getEntityAssetManifest().getWallCapAssets()));
        FileHandle fileHandle = this.createEmptySubdir(assetDefinitionsDir, "plantColorSwatches");
        for (FileHandle colorSwatchFile : modManifest.getEntityAssetManifest().getPlantColorSwatchFiles()) {
            FileUtils.copyFileToDirectory(colorSwatchFile.file(), fileHandle.file());
        }
        FileHandle fileHandle2 = this.createEmptySubdir(assetDir, "temp");
        FileHandle tempEntityDir = this.createEmptySubdir(fileHandle2, "entity");
        FileHandle tempEntityDiffuseDir = this.createEmptySubdir(tempEntityDir, "diffuse");
        FileUtils.copyFile(modManifest.getEntityAssetManifest().getPackJsonFile().file(), tempEntityDiffuseDir.child("pack.json").file());
        FileHandle tempEntityNormalDir = this.createEmptySubdir(tempEntityDir, "normals");
        FileUtils.copyFile(modManifest.getEntityAssetManifest().getPackJsonFile().file(), tempEntityNormalDir.child("pack.json").file());
        for (FileHandle fileHandle3 : modManifest.getEntityAssetManifest().getEntitySpriteFiles()) {
            FileUtils.copyFile(fileHandle3.file(), tempEntityDiffuseDir.child(fileHandle3.name()).file());
        }
        for (FileHandle fileHandle4 : modManifest.getEntityAssetManifest().getEntityNormalMapFiles()) {
            FileUtils.copyFile(fileHandle4.file(), tempEntityNormalDir.child(fileHandle4.name().replace("_NORMALS", "")).file());
        }
        TexturePacker.process(tempEntityDiffuseDir.file().getAbsolutePath(), finalTilesetsDir.file().getAbsolutePath(), "diffuse-entities");
        TexturePacker.process(tempEntityNormalDir.file().getAbsolutePath(), finalTilesetsDir.file().getAbsolutePath(), "normal-entities");
        FileHandle tempGuiDir = this.createEmptySubdir(fileHandle2, "gui");
        for (FileHandle fileHandle5 : modManifest.getGuiManifest().getGuiAssetDirs()) {
            for (FileHandle fileHandle6 : fileHandle5.list()) {
                if (fileHandle6.isDirectory()) continue;
                FileUtils.copyFileToDirectory(fileHandle6.file(), tempGuiDir.file());
            }
        }
        TexturePacker.process(tempGuiDir.file().getAbsolutePath(), finalTilesetsDir.file().getAbsolutePath(), "gui");
        for (FileHandle fileHandle7 : modManifest.getTranslationFiles()) {
            FileUtils.copyFileToDirectory(fileHandle7.file(), assetDir.child("translations").file());
        }
        modManifest.getI18nCollator().outputTo(assetDir.child("translations").child("collated.csv"));
        FileHandle fileHandle8 = assetDir.child("ui-skins").child("cursors");
        for (FileHandle fileHandle9 : modManifest.getGuiManifest().getCursorDirs()) {
            for (FileHandle cursorFile : fileHandle9.list()) {
                FileUtils.copyFileToDirectory(cursorFile.file(), fileHandle8.file());
            }
        }
        FileHandle fileHandle10 = assetDir.child("text");
        if (!fileHandle10.exists()) {
            fileHandle10.mkdirs();
        }
        for (FileHandle modTextDirectory : modManifest.getTextDirectories()) {
            FileUtils.copyDirectory(modTextDirectory.file(), fileHandle10.file());
        }
        FileHandle fileHandle11 = this.createEmptySubdir(fileHandle2, "terrain");
        FileHandle tempTerrainDiffuseDir = this.createEmptySubdir(fileHandle11, "diffuse");
        FileUtils.copyFile(modManifest.getSpritesPackJson().file(), tempTerrainDiffuseDir.child("pack.json").file());
        FileHandle tempTerrainNormalDir = this.createEmptySubdir(fileHandle11, "normal");
        FileUtils.copyFile(modManifest.getSpritesPackJson().file(), tempTerrainNormalDir.child("pack.json").file());
        FileHandle tempMasksDir = this.createEmptySubdir(fileHandle11, "masks");
        FileUtils.copyFile(modManifest.getSpritesPackJson().file(), tempMasksDir.child("pack.json").file());
        LinkedList<FloorType> floorTypes = new LinkedList<FloorType>();
        LinkedList<WallType> wallTypes = new LinkedList<WallType>();
        LinkedList<RoomEdgeType> roomEdgeTypes = new LinkedList<RoomEdgeType>();
        for (TerrainAssetDescriptor terrainAssetDescriptor : modManifest.getTerrainAssetDescriptors()) {
            if (terrainAssetDescriptor.getType().equalsIgnoreCase("floor")) {
                floorTypes.add(terrainAssetDescriptor.getFloorType());
                this.copySprites(tempTerrainDiffuseDir, tempTerrainNormalDir, terrainAssetDescriptor);
                continue;
            }
            if (terrainAssetDescriptor.getType().equalsIgnoreCase("wall")) {
                wallTypes.add(terrainAssetDescriptor.getWallType());
                this.copySprites(tempTerrainDiffuseDir, tempTerrainNormalDir, terrainAssetDescriptor);
                continue;
            }
            if (terrainAssetDescriptor.getType().equalsIgnoreCase("overlap")) {
                for (FileHandle alphaMaskFile : terrainAssetDescriptor.getAlphaMaskFiles()) {
                    FileUtils.copyFile(alphaMaskFile.file(), tempMasksDir.child(alphaMaskFile.name()).file());
                }
                continue;
            }
            if (terrainAssetDescriptor.getType().equalsIgnoreCase("room-edge")) {
                roomEdgeTypes.add(terrainAssetDescriptor.getRoomEdgeType());
                this.copySprites(tempTerrainDiffuseDir, tempTerrainNormalDir, terrainAssetDescriptor);
                continue;
            }
            throw new IOException("Unrecognised sprite type " + terrainAssetDescriptor.getType() + " from " + ReflectionToStringBuilder.toString(terrainAssetDescriptor));
        }
        for (FileHandle spriteFile : modManifest.getEntityAssetManifest().getTerrainSpriteFiles()) {
            FileUtils.copyFile(spriteFile.file(), tempTerrainDiffuseDir.child(spriteFile.name()).file());
        }
        for (FileHandle normalMapSpriteFile : modManifest.getEntityAssetManifest().getTerrainNormalMapFiles()) {
            FileUtils.copyFile(normalMapSpriteFile.file(), tempTerrainNormalDir.child(normalMapSpriteFile.name().replace("_NORMALS", "")).file());
        }
        FileUtils.writeStringToFile(definitionsDir.child("walls.json").file(), this.objectMapper.writeValueAsString(wallTypes));
        FileUtils.writeStringToFile(definitionsDir.child("floors.json").file(), this.objectMapper.writeValueAsString(floorTypes));
        FileUtils.writeStringToFile(definitionsDir.child("room-edges.json").file(), this.objectMapper.writeValueAsString(roomEdgeTypes));
        TexturePacker.process(tempTerrainDiffuseDir.file().getAbsolutePath(), finalTilesetsDir.file().getAbsolutePath(), "diffuse-terrain");
        TexturePacker.process(tempTerrainNormalDir.file().getAbsolutePath(), finalTilesetsDir.file().getAbsolutePath(), "normals-terrain");
        TexturePacker.process(tempMasksDir.file().getAbsolutePath(), finalTilesetsDir.file().getAbsolutePath(), "masks");
        FileUtils.deleteDirectory(fileHandle2.file());
    }

    private void copySprites(FileHandle tempDiffuseDir, FileHandle tempNormalDir, TerrainAssetDescriptor terrainAssetDescriptor) throws IOException {
        for (FileHandle diffuseSpriteFile : terrainAssetDescriptor.getDiffuseFiles()) {
            FileUtils.copyFile(diffuseSpriteFile.file(), tempDiffuseDir.child(diffuseSpriteFile.name()).file());
        }
        for (FileHandle normalMapFile : terrainAssetDescriptor.getNormalMapFiles()) {
            String normalMapFileName = normalMapFile.name();
            String nameMatchingDiffuseName = StringUtils.remove(normalMapFileName, "_NORMALS");
            FileUtils.copyFile(normalMapFile.file(), tempNormalDir.child(nameMatchingDiffuseName).file());
        }
    }

    private FileHandle createEmptySubdir(FileHandle assetDir, String subDirName) {
        FileHandle subDir = assetDir.child(subDirName);
        if (subDir.exists()) {
            subDir.deleteDirectory();
        }
        subDir.mkdirs();
        return subDir;
    }
}

